/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Id: PNM_PNIOAPCTL_Functionlist.h 10500 2010-09-14 11:56:19Z Benjamin $
   Last Modification:
    $LastChangedBy: Benjamin $
    $LastChangedDate: 2010-09-14 13:56:19 +0200 (Di, 14 Sep 2010) $
    $LastChangedRevision: 10500 $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    PNIO APCTL
    Task function list for configuration file
       
   Changes:
 
    Date        Author       Description
    ----------- ------------ ---------------------------------------------------------
    2010-09-14  B. Meyer     introduced new startup parameter version 3 with new parameters
                                to be able to configure the PHYs

    2010-04-12  B. Meyer     introduced new startup parameter version 2 with new parameter
                                ulEthPortCnt to fix mantis #9320
        
**************************************************************************************/
/**
 * @file PNIOAPCTL_Functionlist.h
 * @brief PNIO APCTL - function list
 *
 * The header has to be included in the configuration source file of firmware.
 * Use the content of header file to configure the startup parameter of tasks
 * and to define the entry point <code>TaskEnter_PNM_PNIOAPCTL</code>
 * of task.
 */
#ifndef __PNIO_APCTL_FUNCTIONLIST_H
#define __PNIO_APCTL_FUNCTIONLIST_H


/*************************************************************************************/
/** @name Prototypes
 *
 * The following prototypes are declared to represent
 * - the entry point of task
 * - the exit point of task to delete only the task resources (exit)
 * - the exit point of task to force a friendly shutdown (leave)
 * @{
 */

TLR_RESULT
TaskExit_PNM_PNIOAPCTL
(
 TLR_VOID FAR* pvRsc
);

TLR_RESULT
TaskEnter_PNM_PNIOAPCTL
(
 TLR_VOID FAR* pvInit
);

/** @} */


/*************************************************************************************/
/** @name Task Version
 *
 * Subsequently the version of task is defined.
 */

/** version of task startup parameter */
#define PNIO_APCTL_STARTUP_PARAM_VERSION_5   (5)


/*************************************************************************************/
/** @name Startup Parameter
 *
 * The following definition represent the task startup parameter.
 * @{
 */

/** flags to be used in ulStartupFlags */
#define PNIO_APCTL_TASK_FLAG_DEACTIVATE_RCX_QUE_LOG_CLEAR_SET    (1) /* do not use the following services on task startup */
                                                                     /* RCX_QUE_LOG_CLR_REQ */
                                                                     /* RCX_QUE_LOG_SET_REQ */


/** task startup parameter */
typedef struct PNIO_APCTL_STARTUPPARAMETER_Ttag  PNIO_APCTL_STARTUPPARAMETER_V5_T;

/** task startup parameter
 *
 * The structure represent a set of the startup parameter, which can be defined
 * or have to be defined to configure the task.
 */
struct PNIO_APCTL_STARTUPPARAMETER_Ttag    /* task startup parameter */
{
  TLR_UINT32    ulTaskIdentifier;
  TLR_UINT32    ulParamVersion;
  
  /** DPM Channel Number for HIF */
  TLR_UINT32  ulDPMChannel;
  /** maximum number of configured IO-Devices */
  TLR_UINT32  ulMaxIODevCnt;

  /* new for V2 */
  /* number of EthernetPorts to use */
  TLR_UINT32  ulEthPortCnt;

  /* new for V3 */
  /* name of PHY0 to identify */
  TLR_STR*      pszPhy0Name;
  /* instance of PHY0 */
  TLR_UINT32    ulPhy0Instance;
  /* name of PHY1 to identify */
  TLR_STR*      pszPhy1Name;
  /* instance of PHY 1 */
  TLR_UINT32    ulPhy1Instance;

  /* new for v4 */
  /* address used for DMA */
  TLR_UINT32    ulDmaAddress;

  /* new for v5 */
  /* flags to modify task behavior, see above */
  TLR_UINT32    ulStartupFlags;
};

/** @} */


/*************************************************************************************/
#endif /* #ifndef __PNIO_APCTL_FUNCTIONLIST_H */
